import '../styles/globals.css';
import Head from 'next/head';
import { Toaster } from 'react-hot-toast';
import { Provider } from 'react-redux';
import store from '../store/store';
import { AuthProvider } from '../contexts/AuthContext';
import { OrgProvider } from '../contexts/OrgContext';
import { CartProvider } from '../contexts/CartContext';
import DashboardLayout from '../components/DashboardLayout';
import { useRouter } from 'next/router';

export default function App({ Component, pageProps }) {
  const router = useRouter();
  const isDashboard = router.pathname.startsWith('/dashboard');

  const content = (
    <>
      <Component {...pageProps} />
      <Toaster position="top-right" />
    </>
  );

  return (
    <Provider store={store}>
      <AuthProvider>
        <OrgProvider>
          <CartProvider>
        <Head>
          <link rel="icon" type="image/png" href="/assets/logo.png" />
        </Head>
        {isDashboard ? <DashboardLayout>{content}</DashboardLayout> : content}
          </CartProvider>
        </OrgProvider>
      </AuthProvider>
    </Provider>
  );
}
